import { View, Dimensions, FlatList, StyleSheet } from "react-native";
import React from "react";
import SkeletonElement from "../../SkeletonElement";
import dpr from "../../../../screens/Utilities/CustomStyleAttribute/dpr";
import { categoriesStyle } from "../../../../screens/Home/FeatureCategories/featureCategoriesStyle";
import { filterHomeStyle } from "../../../../screens/Filter/FilterHome/FilterHomeStyle";
const { width } = Dimensions.get("window");

const RenderItem = ({ item }) => {
    return (
        <View
            style={[
                styles.itemCont,
                categoriesStyle.item,
                filterHomeStyle.sellerItem,
            ]}
        >
            <SkeletonElement wrapperStyle={styles.wrapperStyle}/>
        </View>
    );
};

const BestSellersSkeleton = () => {
    return (
        <FlatList
            data={[1, 2, 3, 4, 5, 6]}
            renderItem={({ item }) => <RenderItem item={item} />}
            keyExtractor={(_, i) => "key" + i}
            listKey={(_, i) => `listKey-b${i}`}
            showsHorizontalScrollIndicator={false}
            numColumns={3}
            columnWrapperStyle={styles.columnWrapper}
        />
    );
};

export default BestSellersSkeleton;

const styles = StyleSheet.create({
    itemCont: {
        marginTop: dpr(20),
        borderColor: "white",
    },
    columnWrapper: {
        justifyContent: "flex-start",
    },
    wrapperStyle: {
        height: dpr(105),
        width: dpr(100),
    },
});
